unit uMessSender;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, uMessageCommons, Winsock;

type
  TForm1 = class(TForm)
    imPicture: TImage;
    edInteger: TEdit;
    mmText: TMemo;
    btnSendImage: TButton;
    btnSendInteger: TButton;
    btnSendString: TButton;
    OpenDialog1: TOpenDialog;
    procedure btnSendIntegerClick(Sender: TObject);
    procedure imPictureClick(Sender: TObject);
    procedure btnSendStringClick(Sender: TObject);
    procedure btnSendImageClick(Sender: TObject);
  private
    { Private declarations }
    procedure SendData(aData: TMemoryStream);
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  fwsaData:WSADATA;

implementation

{$R *.DFM}

procedure TForm1.imPictureClick(Sender: TObject);
begin
   if OpenDialog1.Execute then
      imPicture.Picture.LoadFromFile(OpenDialog1.FileName);
end;

procedure TForm1.SendData(aData: TMemoryStream);
var
   _sh: THandle;
   _remote: TSockAddr;
begin
   _sh:= Socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
   if (_sh = INVALID_SOCKET) then
      raise Exception.Create('failed to create a new socket');
   try
      _remote.sin_family:= AF_INET;
      _remote.sin_port:= htons(1111);
      _remote.sin_addr.s_addr := inet_addr(pchar('127.0.0.1'));
      if SendTo(_sh, aData.memory^, aData.Size, 0, _remote, SizeOf(_remote)) = SOCKET_ERROR then
         raise Exception.Create('failed to send data');
  finally
    if (shutdown(_sh,2) = 0) then
      CloseSocket(_sh);
  end;
end;

procedure TForm1.btnSendIntegerClick(Sender: TObject);
var
   _msg: TMemoryStream;
   _int: integer;
begin
   _msg:= TMemoryStream.Create;
   try
      { write data type }
      _int:= ord(mtInteger);
      _msg.Write(_int, SizeOf(integer));
      { write data }
      _int:= StrToIntDef(edInteger.Text, 0);
      _msg.Write(_int, SizeOf(integer));
      { send the message }
      SendData(_msg);
   finally
      _msg.Free;
   end;
end;

procedure TForm1.btnSendStringClick(Sender: TObject);
var
   _msg: TMemoryStream;
   _int: integer;
   _ln: integer;
   _str: string;
begin
   _msg:= TMemoryStream.Create;
   try
      { write data type }
      _int:= ord(mtString);
      _msg.Write(_int, SizeOf(integer));
      { write data }
      _str:= mmText.Text;
      _ln:= length(_str);
      if (_ln > 0) then
         _msg.Write(_str[1], _ln);
      { send the message }
      SendData(_msg);
   finally
      _msg.Free;
   end;
end;

procedure TForm1.btnSendImageClick(Sender: TObject);
var
   _msg: TMemoryStream;
   _int: integer;
begin
   _msg:= TMemoryStream.Create;
   try
      { write data type }
      _int:= ord(mtImage);
      _msg.Write(_int, SizeOf(integer));
      { write data }
      imPicture.Picture.Bitmap.SaveToStream(_msg);
      { send the message }
      SendData(_msg);
   finally
      _msg.Free;
   end;
end;

initialization
   if (WSAStartup ($0101, fWsaData)<>0) then
      raise Exception.Create('Failed to initialize winsock');

finalization
   WSACleanup;
   
end.
